package com.cleo.clarify.audit;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TransactionAuditor {

	private static ResultSet auditRS;
	static final String auditQuery = "SELECT \"EDI\".\"EDITransactions\",\"ACK\".\"AckCount\",\"EDI\".\"Year\",\"EDI\".\"Month\" " 
			+ "FROM(SELECT count(*) AS \"AckCount\", date_part('YEAR', to_timestamp(lom.\"DATE\" / 1000)::date)::varchar AS \"Year\", "
			+ "date_part('MONTH', to_timestamp(lom.\"DATE\" / 1000)::date)::int AS \"Month\" FROM \"EBI\".\"LOG_OF_MESSAGE\" lom "
			+ "WHERE lom.\"DATE\" BETWEEN ? AND ? AND (\"MESSAGE_ID\" = '997' OR \"MESSAGE_ID\" = '999' OR \"MESSAGE_ID\" = 'CONTRL') "
			+ "GROUP BY date_part('YEAR', to_timestamp(lom.\"DATE\" / 1000)::date)::varchar, "
			+ "date_part('MONTH', to_timestamp(lom.\"DATE\" / 1000)::date)::int ORDER BY 2, 3) AS \"ACK\" "
			+ "RIGHT JOIN (SELECT count(*) AS \"EDITransactions\", date_part('YEAR', to_timestamp(lom.\"DATE\" / 1000)::date)::varchar AS \"Year\", "
			+ "date_part('MONTH', to_timestamp(lom.\"DATE\" / 1000)::date)::int AS \"Month\" FROM \"EBI\".\"LOG_OF_MESSAGE\" lom "
			+ "WHERE lom.\"DATE\" BETWEEN ? AND ? AND (\"MESSAGE_ID\" <> '997' AND \"MESSAGE_ID\" <> '999' AND \"MESSAGE_ID\" <> 'CONTRL' AND \"MESSAGE_ID\" IS NOT NULL) "
			+ "GROUP BY date_part('YEAR', to_timestamp(lom.\"DATE\" / 1000)::date)::varchar, "
			+ "date_part('MONTH', to_timestamp(lom.\"DATE\" / 1000)::date)::int ORDER BY 2, 3) "
			+ "AS \"EDI\" ON \"ACK\".\"Year\" = \"EDI\".\"Year\" AND \"ACK\".\"Month\" = \"EDI\".\"Month\"";

	public static String generateSaveFileLoc(String paramString1, String paramString2) {
		
		SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_hhmmss");
		Date localDate = new Date();

		return paramString2 + "\\" + paramString1 + "_" + localSimpleDateFormat.format(localDate) + ".csv";
	}

	private static String getQueryResults() throws IOException, SQLException {

		ResultSetMetaData localResultSetMetaData = auditRS.getMetaData();

		String str = "EDITransactions,AckCount,Year,Month\n";
		while (auditRS.next())
		{
			for (int i = 1; i <= localResultSetMetaData.getColumnCount(); i++)
			{
				int j = localResultSetMetaData.getColumnType(i);
				if ((j == 12) || (j == 1)) {
					str = str.concat(auditRS.getString(i));
				} else {
					str = str.concat(Long.toString(auditRS.getLong(i)));
				}
				if (i < localResultSetMetaData.getColumnCount()) {
					str = str.concat(",");
				}
			}
			str = str.concat("\n");
		}
		return str;
	}
	
	private static String removeCacheString(String url) {
		if (url.contains(":cache")) {
			return url.replaceAll(":cache", "");
		}
		else
			return url;
			
	}

	public static String transactionAudit(String username, String password, String driverName, String url, String startDate, String endDate) {
		
		Connection localConnection = null;
		PreparedStatement pStmt = null;

		String str = "";
		try {

            Class.forName(driverName);
			
			localConnection = DriverManager.getConnection(removeCacheString(url), username, password);
			pStmt = localConnection.prepareStatement(auditQuery);
			
			long starttimeInMillis = Timestamp.valueOf(startDate).getTime();
			long endtimeInMillis = Timestamp.valueOf(endDate).getTime();
			pStmt.setLong(1, starttimeInMillis);
			pStmt.setLong(2, endtimeInMillis);
			pStmt.setLong(3, starttimeInMillis);
			pStmt.setLong(4, endtimeInMillis);

			auditRS = pStmt.executeQuery();
			if (auditRS != null) {
				str = getQueryResults();
			}
			return str;
		}
		catch (IOException localIOException) {
			localIOException.printStackTrace();
		}
		catch (SQLException localSQLException10) {
			localSQLException10.printStackTrace();
		}
		catch (Exception localException) {
			localException.printStackTrace();
		}
		finally {
			try {
				if (localConnection != null) {
					localConnection.close();
				}
			}
			catch (SQLException localSQLException17) {
				localSQLException17.printStackTrace();
			}
			try {
				if (auditRS != null) {
					auditRS.close();
				}
			}
			catch (SQLException localSQLException19) {}
		}
		return null;
	}
	
	public static void main(String[] args) {

		
	}
}
